/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.dsl.naming;

import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.UniqueConstraintNamingStrategy;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.PersonWithGender;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class UniqueConstraintNamingStrategyTest {
    UniqueConstraintNamingStrategyTest() {
    }

    static Iterable<Arguments> defaultImplementation_data() {
        Table abstractVehicleTable = new Table(null, "AbstractVehicle");
        Column timestampColumn = abstractVehicleTable.addColumn("timestamp", String.class);
        PropertyAccessor timestampPropertyAccessor = PropertyAccessor.fromMethodReference(AbstractVehicle::getTimestamp, AbstractVehicle::setTimestamp);
        Table personTable = new Table(null, "Person");
        Column mainBicycleColumn = personTable.addColumn("mainBicycle", String.class);
        PropertyAccessor mainBicyclePropertyAccessor = PropertyAccessor.fromMethodReference(Person::getMainBicycle, Person::setMainBicycle);
        Column principalBikeColumn = personTable.addColumn("principalBike", String.class);
        Table personWithGenderTable = new Table(null, "PersonWithGender");
        Column genderColumn = personWithGenderTable.addColumn("gender", String.class);
        EmbeddableMappingConfiguration.Linkage personWithGenderGender_withOverriddenName = (EmbeddableMappingConfiguration.Linkage)Mockito.mock(EmbeddableMappingConfiguration.Linkage.class);
        PropertyAccessor genderPropertyAccessor = PropertyAccessor.fromMethodReference(PersonWithGender::getGender, PersonWithGender::setGender);
        return Arrays.asList((Object[])new Arguments[]{Arguments.arguments((Object[])new Object[]{timestampPropertyAccessor, timestampColumn, "abstract_vehicle_timestamp_key"}), Arguments.arguments((Object[])new Object[]{mainBicyclePropertyAccessor, mainBicycleColumn, "person_main_bicycle_key"}), Arguments.arguments((Object[])new Object[]{mainBicyclePropertyAccessor, principalBikeColumn, "person_principal_bike_key"}), Arguments.arguments((Object[])new Object[]{genderPropertyAccessor, genderColumn, "person_with_gender_gender_key"}), Arguments.arguments((Object[])new Object[]{mainBicyclePropertyAccessor, principalBikeColumn, "person_principal_bike_key"})});
    }

    @ParameterizedTest
    @MethodSource(value={"defaultImplementation_data"})
    void defaultImplementation(ReversibleAccessor accessor, Column column, String expectedIndexName) {
        String constraintName = UniqueConstraintNamingStrategy.DEFAULT.giveName((ValueAccessPoint)accessor, column);
        Assertions.assertThat((String)constraintName).isEqualTo(expectedIndexName);
    }
}

